/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.tuple.Quadruple;
import io.gitlab.jfronny.commons.tuple.Single;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Triple<T1, T2, T3>(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3> Triple<T1, T2, T3> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
        return new Triple<T1, T2, T3>(val1, val2, val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T, T2, T3> map1(@NotNull Function<T1, T> mapper) {
        return new Triple<T, T2, T3>(Objects.requireNonNull(mapper).apply(this.val1), this.val2, this.val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T> Function<Triple<T1, T2, T3>, Triple<T, T2, T3>> mapping1(@NotNull Function<T1, T> mapper) {
        return triple -> triple.map1(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T1, T, T3> map2(@NotNull Function<T2, T> mapper) {
        return new Triple<T1, T, T3>(this.val1, Objects.requireNonNull(mapper).apply(this.val2), this.val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T> Function<Triple<T1, T2, T3>, Triple<T1, T, T3>> mapping2(@NotNull Function<T2, T> mapper) {
        return triple -> triple.map2(mapper);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T1, T2, T> map3(@NotNull Function<T3, T> mapper) {
        return new Triple<T1, T2, T>(this.val1, this.val2, Objects.requireNonNull(mapper).apply(this.val3));
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T> Function<Triple<T1, T2, T3>, Triple<T1, T2, T>> mapping3(@NotNull Function<T3, T> mapper) {
        return triple -> triple.map3(mapper);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<T1, Tuple<T2, T3>> slice1() {
        return Tuple.of(this.val1, Tuple.of(this.val2, this.val3));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<Tuple<T1, T2>, T3> slice2() {
        return Tuple.of(Tuple.of(this.val1, this.val2), this.val3);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T2, T3, T1> lShift() {
        return new Triple<T2, T3, T1>(this.val2, this.val3, this.val1);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T3, T1, T2> rShift() {
        return new Triple<T3, T1, T2>(this.val3, this.val1, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T2, T1, T3> swapL() {
        return new Triple<T2, T1, T3>(this.val2, this.val1, this.val3);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T1, T3, T2> swapR() {
        return new Triple<T1, T3, T2>(this.val1, this.val3, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T3, T2, T1> reverse() {
        return new Triple<T3, T2, T1>(this.val3, this.val2, this.val1);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T4> Quadruple<T1, T2, T3, T4> concat(@Nullable T4 val4) {
        return Quadruple.of(this.val1, this.val2, this.val3, val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T4> Quadruple<T1, T2, T3, T4> concat(@NotNull Single<T4> val4) {
        return Quadruple.of(this.val1, this.val2, this.val3, val4.val());
    }

    public static <T1, T2, T3, A1, A2, A3, R1, R2, R3> Collector<Triple<T1, T2, T3>, Triple<A1, A2, A3>, Triple<R1, R2, R3>> collector(final Collector<T1, A1, R1> val1, final Collector<T2, A2, R2> val2, final Collector<T3, A3, R3> val3) {
        return new Collector<Triple<T1, T2, T3>, Triple<A1, A2, A3>, Triple<R1, R2, R3>>(){

            @Override
            public Supplier<Triple<A1, A2, A3>> supplier() {
                Supplier firstSupplier = val1.supplier();
                Supplier secondSupplier = val2.supplier();
                Supplier thirdSupplier = val3.supplier();
                return () -> Triple.of(firstSupplier.get(), secondSupplier.get(), thirdSupplier.get());
            }

            @Override
            public BiConsumer<Triple<A1, A2, A3>, Triple<T1, T2, T3>> accumulator() {
                BiConsumer firstAccumulator = val1.accumulator();
                BiConsumer secondAccumulator = val2.accumulator();
                BiConsumer thirdAccumulator = val3.accumulator();
                return (a, b) -> {
                    firstAccumulator.accept(a.val1, b.val1);
                    secondAccumulator.accept(a.val2, b.val2);
                    thirdAccumulator.accept(a.val3, b.val3);
                };
            }

            @Override
            public BinaryOperator<Triple<A1, A2, A3>> combiner() {
                BinaryOperator firstCombiner = val1.combiner();
                BinaryOperator secondCombiner = val2.combiner();
                BinaryOperator thirdCombiner = val3.combiner();
                return (a, b) -> Triple.of(firstCombiner.apply(a.val1, b.val1), secondCombiner.apply(a.val2, b.val2), thirdCombiner.apply(a.val3, b.val3));
            }

            @Override
            public Function<Triple<A1, A2, A3>, Triple<R1, R2, R3>> finisher() {
                Function firstFinisher = val1.finisher();
                Function secondFinisher = val2.finisher();
                Function thirdFinisher = val3.finisher();
                return a -> Triple.of(firstFinisher.apply(a.val1), secondFinisher.apply(a.val2), thirdFinisher.apply(a.val3));
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                HashSet<Collector.Characteristics> characteristics = new HashSet<Collector.Characteristics>(val1.characteristics());
                characteristics.retainAll(val2.characteristics());
                characteristics.retainAll(val3.characteristics());
                return characteristics;
            }
        };
    }
}

